package org.msh.tb.bd.dashboard.query;

import org.msh.tb.entities.enums.TbField;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Mauricio on 24/05/2017.
 */
public class Indicator08Query extends IndicatorQuery {

    @Override
    public List<Object[]> getSummaryResult(){
        List<Object[]> ret;

        if (getSelectedAdminUnit() != null) {
            // create administrative unit condition
            String auCondition = "and au.id = " + getSelectedAdminUnit().getId();
            ret = getQueryResult(auCondition);
        } else {
            // this will return the result for first level of admin unit
            List<Object[]> results = getDetailedResult();

            ret = new ArrayList<Object[]>();
            // get root results
            for(Object[] o : results) {
                String adminUnitName = (String) o[0];
                if ("root".equals(adminUnitName)) {
                    ret.add(o);
                }
            }
        }

        return ret;
    }

    @Override
    public List<Object[]> getDetailedResult(){
        // create administrative unit condition
        String auCondition = "";

        if (getSelectedAdminUnit() != null) {
            auCondition = "and au.code like '" + getSelectedAdminUnit().getCode() + "%' ";
            int level = getSelectedAdminUnit().getCountryStructure().getLevel() + 1;
            auCondition += "and au.countryStructure.level = " + level;
        } else {
            auCondition = "and au.countryStructure.level = 1 ";
        }

        //get database result and include for each result its rate
        List<Object[]> ret = getQueryResult(auCondition);
        Map<String, Long> rootResults = new HashMap<String, Long>();

        for (Object[] o : ret) {
            String fvName = (String)o[1];
            Long current = rootResults.get(fvName);
            Long newValue = current == null ? (Long)o[2] : (Long)o[2] + current;

            rootResults.put(fvName, newValue);
        }

        for (String key : rootResults.keySet()) {
            Object[] o = new Object[] {"root", key, rootResults.get(key)};
            ret.add(o);
        }

        return ret;
    }

    @Override
    public Float calculateRate(Object[] o) {
        // no rate calculation
        return null;
    }

    @Override
    protected List<Object[]> includeRate(List<Object[]> result) {
        // do nothing
        return result;
    }

    @Override
    protected List<Object[]> getQueryResult(String adminUnitCondition) {
        // query indicator result
        // get population by administrative units child of auSelected
        // get new and relapses cases notified inside each of these administrative units
        List<Object[]> result = getEntityManager().createQuery("select au.name.name1, fv.name.name1, " +
                "(select count(*) " +
                    "from TbCaseBD c join c.patient p " +
                    "where c.notificationUnit.adminUnit.code like concat(au.code,'%' ) " +
                    "and c.patientRefToFv.id = fv.id " +
                    "and c.registrationDate between :iniDate and :endDate and c.classification = 0 " +
                    "and p.workspace.id = :wsId )" +
                "from AdministrativeUnit au, FieldValue fv " +
                "where fv.field = :field " +
                "and au.workspace.id = :wsId and fv.workspace.id = :wsId " + adminUnitCondition +
                " order by fv.displayOrder")
                .setParameter("iniDate", getIniDate())
                .setParameter("endDate", getEndDate())
                .setParameter("field", TbField.MEDEXAM_REFTOTYPE)
                .setParameter("wsId", getWorkspace().getId())
                .getResultList();

        return result;
    }
}
